Imports System.Text
Imports ComponentPro

Namespace AdvancedDemo.Samples.Function_and_Property
	Friend Class ArticleAuthor
		Public ReadOnly Property FullName() As String
			Get
				Return "Leo Dang"
			End Get
		End Property
	End Class

	Friend Class Article
		Public ReadOnly Property ArticleId() As Integer
			Get
				Return 100
			End Get
		End Property
		Public ReadOnly Property ArticleAuthor() As ArticleAuthor
			Get
				Return New ArticleAuthor()
			End Get
		End Property
		Public Function GetFullName() As String
			Return Me.ArticleAuthor.FullName.ToUpper()
		End Function
	End Class

	Friend Class Dot_NET_Support
		Inherits TemplateExampleBase
		''' <summary>
		''' Generates output from a template file.
		''' </summary>
		''' <param name="templateSourceDirectory">The path to the directory that contains the template file.</param>
		''' <param name="templateFile">The template file path.</param>
		''' <param name="templateSource">The template source loaded from the template file.</param>
		''' <returns>The generated output.</returns>
		Public Overrides Function Generate(ByVal templateSourceDirectory As String, ByVal templateFile As String, ByVal templateSource As String) As String
			' Create a new instance of the TemplateEngine class.
			Dim dt As New TemplateEngine()

			' Load template content from a file.
			dt.LoadFromString(templateSource)
			dt.SetValue("TemplateSourceDirectory", templateSourceDirectory)

			Dim art As New Article()
			dt.SetValue("art", art)

			' Generate output.
			Dim output As String = dt.Run()

			Return output
		End Function
	End Class
End Namespace
